import { Link, useLocation } from 'react-router-dom'
import { Calendar, Plus, Facebook, Instagram, Youtube, Phone, Mail, MapPin, Clock } from 'lucide-react'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="layout">
      <header className="header">
        <div className="header-content">
          <h1 className="logo">FitZone</h1>
          <nav className="nav">
            <Link 
              to="/" 
              className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
            >
              <Calendar className="nav-icon" size={20} />
              <span>Записи</span>
            </Link>
            <Link 
              to="/book" 
              className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
            >
              <Plus className="nav-icon" size={20} />
              <span>Запись</span>
            </Link>
          </nav>
        </div>
      </header>
      <main className="main-content">
        {children}
      </main>
      <footer className="footer">
        <div className="footer-wrapper">
          <div className="footer-main">
            <div className="footer-col">
              <div className="footer-brand">
                <div className="footer-logo">
                  <h2>FitZone</h2>
                </div>
                <p>Ваш путь к здоровому образу жизни. Профессиональные тренировки и индивидуальный подход с 2012 года.</p>
                <div className="footer-social">
                  <a href="#" className="social-btn" aria-label="Facebook">
                    <Facebook className="social-icon" size={20} />
                  </a>
                  <a href="#" className="social-btn" aria-label="Instagram">
                    <Instagram className="social-icon" size={20} />
                  </a>
                  <a href="#" className="social-btn" aria-label="Youtube">
                    <Youtube className="social-icon" size={20} />
                  </a>
                </div>
              </div>
            </div>
            <div className="footer-col">
              <h4>Быстрые ссылки</h4>
              <ul>
                <li><Link to="/book">Записаться онлайн</Link></li>
                <li><a href="#">Наши программы</a></li>
                <li><a href="#">Тренеры</a></li>
                <li><a href="#">Цены</a></li>
                <li><a href="#">Акции</a></li>
              </ul>
            </div>
            <div className="footer-col">
              <h4>Тренировки</h4>
              <ul>
                <li><a href="#">Йога</a></li>
                <li><a href="#">Кроссфит</a></li>
                <li><a href="#">Пилатес</a></li>
                <li><a href="#">Стретчинг</a></li>
                <li><a href="#">Персональные</a></li>
              </ul>
            </div>
            <div className="footer-col">
              <h4>Контакты</h4>
              <div className="footer-contacts">
                <div className="footer-contact-item">
                  <Phone className="contact-icon" size={18} />
                  <div>
                    <span>+7 (495) 123-45-67</span>
                    <span className="contact-label">Круглосуточно</span>
                  </div>
                </div>
                <div className="footer-contact-item">
                  <Mail className="contact-icon" size={18} />
                  <span>info@fitzone.ru</span>
                </div>
                <div className="footer-contact-item">
                  <MapPin className="contact-icon" size={18} />
                  <span>Москва, ул. Фитнесная, 10</span>
                </div>
                <div className="footer-contact-item">
                  <Clock className="contact-icon" size={18} />
                  <span>Пн-Вс: 7:00 - 23:00</span>
                </div>
              </div>
            </div>
          </div>
          <div className="footer-divider"></div>
          <div className="footer-bottom">
            <p>&copy; 2025 FitZone. Все права защищены.</p>
            <div className="footer-links-bottom">
              <a href="#">Политика конфиденциальности</a>
              <a href="#">Пользовательское соглашение</a>
              <a href="#">Карта сайта</a>
            </div>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

